/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.mossable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.blocks.PatchSpreader;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.mossable.MossSpreader;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public interface Mossable
extends Weatherable {
    public static final Supplier<BiMap<class_2248, class_2248>> MOSS_LEVEL_INCREASES = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)class_2246.field_10340, (Object)ModBlocks.MOSSY_STONE.get()).put((Object)class_2246.field_10440, (Object)ModBlocks.MOSSY_STONE_STAIRS.get()).put((Object)class_2246.field_10454, (Object)ModBlocks.MOSSY_STONE_SLAB.get()).put((Object)class_2246.field_10445, (Object)class_2246.field_9989).put((Object)ModBlocks.STONE_WALL.get(), (Object)ModBlocks.MOSSY_STONE_WALL.get()).put((Object)class_2246.field_10596, (Object)class_2246.field_10207).put((Object)class_2246.field_10351, (Object)class_2246.field_10405).put((Object)class_2246.field_10625, (Object)class_2246.field_9990).put((Object)class_2246.field_10056, (Object)class_2246.field_10065).put((Object)class_2246.field_10552, (Object)ModBlocks.MOSSY_CHISELED_STONE_BRICKS.get()).put((Object)class_2246.field_10392, (Object)class_2246.field_10173).put((Object)class_2246.field_10131, (Object)class_2246.field_10024).put((Object)class_2246.field_10252, (Object)class_2246.field_10059).put((Object)class_2246.field_10104, (Object)ModBlocks.MOSSY_BRICKS.get()).put((Object)class_2246.field_10089, (Object)ModBlocks.MOSSY_BRICK_STAIRS.get()).put((Object)class_2246.field_10191, (Object)ModBlocks.MOSSY_BRICK_SLAB.get()).put((Object)class_2246.field_10269, (Object)ModBlocks.MOSSY_BRICK_WALL.get());
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_brick_slab", "immersive_weathering:vertical_mossy_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_cobblestone_slab", "quark:vertical_mossy_cobblestone_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "quark:vertical_stone_brick_slab", "quark:vertical_mossy_stone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<class_2248, class_2248>)builder, "immersive_weathering:vertical_stone_slab", "immersive_weathering:vertical_mossy_stone_slab");
        IWPlatformStuff.addExtraMossyBlocks((ImmutableBiMap.Builder<class_2248, class_2248>)builder);
        return builder.build();
    });
    public static final Supplier<BiMap<class_2248, class_2248>> MOSS_LEVEL_DECREASES = Suppliers.memoize(() -> MOSS_LEVEL_INCREASES.get().inverse());

    public static class_2680 getUnaffectedMossBlock(class_2680 state) {
        class_2248 block2 = state.method_26204();
        class_2248 block3 = (class_2248)MOSS_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (class_2248)MOSS_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2.method_34725(state);
    }

    public static class_2680 getMossyBlock(class_2680 state) {
        class_2248 block2 = state.method_26204();
        class_2248 block3 = (class_2248)MOSS_LEVEL_INCREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (class_2248)MOSS_LEVEL_INCREASES.get().get((Object)block2);
        }
        return block2.method_34725(state);
    }

    public static Optional<class_2248> getDecreasedMossBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)MOSS_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Optional<class_2248> getIncreasedMossBlock(class_2248 block) {
        return Optional.ofNullable((class_2248)MOSS_LEVEL_INCREASES.get().get((Object)block));
    }

    default public Optional<class_2680> getNextMossy(class_2680 state) {
        return Mossable.getIncreasedMossBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    default public Optional<class_2680> getPreviousMossy(class_2680 state) {
        return Mossable.getDecreasedMossBlock(state.method_26204()).map(block -> block.method_34725(state));
    }

    public MossSpreader getMossSpreader();

    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == MossLevel.class) {
            return Optional.of(this.getMossSpreader());
        }
        return Optional.empty();
    }

    @Override
    default public boolean shouldWeather(class_2680 state, class_2338 pos, class_1937 level) {
        if (!CommonConfigs.MOSS_SPREADING_ENABLED.get().booleanValue()) {
            return false;
        }
        return this.getMossSpreader().getWantedWeatheringState(false, pos, level);
    }

    public MossLevel getMossLevel();

    @Override
    public boolean isWeathering(class_2680 var1);

    @Override
    default public void tryWeather(class_2680 state, class_3218 serverLevel, class_2338 pos, class_5819 random) {
        if (random.method_43057() < this.getWeatherChanceSpeed()) {
            class_2680 newState;
            Optional<class_2680> opt = Optional.empty();
            if (this.getMossSpreader().getWantedWeatheringState(true, pos, (class_1937)serverLevel)) {
                opt = this.getNextMossy(state);
            }
            if ((newState = opt.orElse((class_2680)state.method_11657(Weatherable.WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)))) != state) {
                serverLevel.method_8652(pos, newState, 2);
                if (!newState.method_28498(Weatherable.WEATHERABLE)) {
                    serverLevel.method_39279(pos, state.method_26204(), 1);
                }
            }
        }
    }

    public static enum MossLevel {
        UNAFFECTED,
        MOSSY;

    }
}

